#include "stdafx.h"
#include "SkinExport.h"
#include "RpWorld.h"

SkinExport::SkinExport()
{
    //SkinModifier=NULL; //derived classes need to set this
    //NumBones=0; //set in derived
    
    VertexMap=NULL;

    //set outputs to null
    SkinMatrixWeights = NULL;
    SkinVertexIndices = NULL;
}

SkinExport::~SkinExport()
{
    if (VertexMap)
    {
        RwFree(VertexMap);
        VertexMap=NULL;
    }
    if (SkinMatrixWeights)
    {
        RwFree(SkinMatrixWeights);
        SkinMatrixWeights=NULL;
    }
    if (SkinVertexIndices)
    {
        RwFree(SkinVertexIndices);
        SkinVertexIndices=NULL;
    }
}

void SkinExport::Export(RpClump *clump, RpAtomic *Atomic)
{
    MakeVertexBoneWeightMap();
    CalculateSkinVertexBoneMap();

    //need to create skinflags somehow and skininversematrices
//    RwFree(VertexMap); later is safer
    if (VertexMap)
    {
        RpSkin *skin = RpSkinCreate(Atomic, NumBones,
            SkinMatrixWeights, SkinVertexIndices, SkinInverseMatrices, SkinFlags);
        /*if (skin)
        {
            int i;
            // set the bonetags to match the frame hierarchy
            for (i=0; i<CSNumBones; i++)
            {                    
                skin->pBoneInfo[i].boneTag = CSBoneIndexTags[i];
            }
        }*/
    
      //  RwFree(skinMatrixWeights);
      //  skinMatrixWeights = NULL;
      //  RwFree(skinVertexIndices);
      //  skinVertexIndices = NULL;
    }
    RwFree(VertexMap);
    VertexMap=NULL;
}

void SkinExport::MakeTransform(void)
{
//we need to transform the skin into the correct space relative to the bones
//& renderware friendly so work out some matrices to do it.
/*    Matrix3 skinMat = node->GetObjTMAfterWSM(m_tvStart);

    //Get a bone node connected to this physique, then find the highest biped part
    //in that bone's hierarchy.
    //Won't work with floating bones of course, but otherwise should be okay.
    INode *boneNode = FindHierarchy(node);
    
    Matrix3 transform;

    //don't ask why, it just works. :-P
    if (boneNode->GetParentNode()->IsRootNode())
    {
        //bone is top of hierarchy
        Matrix3 boneMat = boneNode->GetNodeTM(m_tvStart);        
        boneMat.NoScale();

        if (m_retainObjInWorldSpace)
        {
            Matrix3 parentMat = node->GetParentNode()->
                GetObjTMAfterWSM(m_tvStart);
            parentMat.NoScale();

            transform=skinMat * Inverse( parentMat );
        }
        else
        {
            transform = skinMat *  Inverse(boneMat);
        }
    }
    else
    {
        //bone is a child of something else
        Matrix3 mat = FindTopOfHierarchy( boneNode )->GetObjTMAfterWSM(m_tvStart);
        transform = skinMat * Inverse(mat);
    }

    //don't forget to adjust the skin for the user scale!
    transform *= m_scaleMatrix;
*/
}

void
SkinExport::ProcessSkinNode(INode *node, RpClump *clump)
{
    if (!SkinModifier)
    {
        //error
        return;
    }

    //we need to transform the skin into the correct space relative to the bones
    //& renderware friendly so work out some matrices to do it.
/*    Matrix3 skinMat = node->GetObjTMAfterWSM(m_tvStart);

    //Get a bone node connected to this physique, then find the highest biped part
    //in that bone's hierarchy.
    //Won't work with floating bones of course, but otherwise should be okay.
    INode *boneNode = FindHierarchy(node);
    
    Matrix3 transform;

    //don't ask why, it just works. :-P
    if (boneNode->GetParentNode()->IsRootNode())
    {
        //bone is top of hierarchy
        Matrix3 boneMat = boneNode->GetNodeTM(m_tvStart);        
        boneMat.NoScale();

        if (m_retainObjInWorldSpace)
        {
            Matrix3 parentMat = node->GetParentNode()->
                GetObjTMAfterWSM(m_tvStart);
            parentMat.NoScale();

            transform=skinMat * Inverse( parentMat );
        }
        else
        {
            transform = skinMat *  Inverse(boneMat);
        }
    }
    else
    {
        //bone is a child of something else
        Matrix3 mat = FindTopOfHierarchy( boneNode )->GetObjTMAfterWSM(m_tvStart);
        transform = skinMat * Inverse(mat);
    }

    //don't forget to adjust the skin for the user scale!
    transform *= m_scaleMatrix;

    //Get the vertices & normals & transform them into the correct space...
    RwInt32 *vertexMap = NULL;
    RpAtomic *atomic = NULL;
    
    NodesToFrames::iterator nodeToFrameIt = m_nodesToFrames.find( node );
    RwFrame *myFrame = 0;

    if (nodeToFrameIt != m_nodesToFrames.end())
    {
        myFrame = RwFrameGetParent( nodeToFrameIt->second );
    }
    else
    {
        //uh oh!
        return;
    }

    ExtractGeometryFromNode( node, clump, myFrame, atomic, vertexMap, transform );

    //Get the vertex->bone mappings and build an RpSkin atomic
    if (vertexMap)
    {
        if (atomic)
        {
           RwMatrixWeights  *skinMatrixWeights = 0;
           RwUInt32         *skinVertexIndices = 0;

           CalculateSkinVertexBoneMap(node, vertexMap, CSNumBones, CSBoneIndexNodePointers,
               m_remapper,
               skinMatrixWeights, skinVertexIndices );

           //transform the skin inverse matices into the correspoding position in the frame hierarchy.
           RwMatrix *ltm = RwFrameGetLTM( myFrame );
           RwMatrix *offsetSkinInverseMatrices = new RwMatrix[CSNumBones];
           for (int matNum=0; matNum<CSNumBones; matNum++)
           {
                RwMatrixMultiply( &offsetSkinInverseMatrices[matNum], ltm, &skinInverseMatrices[matNum] );
           }

           RpSkin *skin = RpSkinCreate(atomic, CSNumBones, skinMatrixWeights, skinVertexIndices, offsetSkinInverseMatrices, skinFlags);                

           delete [] offsetSkinInverseMatrices;

           if (skin)
           {
               int i;
               // set the bonetags to match the frame hierarchy
               for (i=0; i<CSNumBones; i++)
               {                    
                   skin->pBoneInfo[i].boneTag = CSBoneIndexTags[i];
               }
           }
       
           RwFree(skinMatrixWeights);
           RwFree(skinVertexIndices);
        }

        RwFree(vertexMap);
    }*/
}

int CompareBoneWeights( const void *Node1, const void *Node2 )
{
   //comparison function for sorting bonenumberweight struct
   float Weight1, Weight2;
   Weight1=((BoneNumberWeight *)Node1)->Weight;
   Weight2=((BoneNumberWeight *)Node2)->Weight;
   if (Weight1<Weight2) return 1;
   else if (Weight1>Weight2) return -1;
   return 0;
}

void
SkinExport::CalculateSkinVertexBoneMap(void)
{
    //assign the weights in Renderware by finding the four largest weights for each vertex
    //RpSkin is a list ordered by vertex number of a 4 byte integer containing
    //the bone numbers and a block of 4 weights to go with this
    //POST: the skinMatrixWeights and skinVertexIndices arrays
    int i,Bone,currentVertex;
    BoneNumberWeight *BoneWeights;

    BoneWeights=(BoneNumberWeight *)RwMalloc(NumBones*sizeof(BoneNumberWeight));

    SkinMatrixWeights = (RwMatrixWeights *)RwMalloc(sizeof(RwMatrixWeights) * remapper->GetNumVertices());
    SkinVertexIndices = (RwUInt32 *)RwMalloc(sizeof(RwUInt32) * remapper->GetNumVertices());
    
    currentVertex=remapper->GetVertex(0)->vertexIndex;
    for (i=0; i<remapper->GetNumVertices(); i++)
    {
        int vertexIndex = remapper->GetVertex(i)->vertexIndex;
        //Make an array of bonenumberweight classes. The BoneNumber is necessary
        //for when the list is sorted later, otherwise the original bone number
        //could not be determined.
        for (Bone=0; Bone<NumBones; ++Bone)
        {
            BoneWeights[Bone].BoneNumber=Bone;
            BoneWeights[Bone].Weight=0;
        }
        //find all the weights for this vertex, summing multiple weights
        while (VertexList[currentVertex]==vertexIndex)
        {
            int BoneNumber=BoneNumberList[currentVertex];
            BoneWeights[BoneNumber].Weight+=WeightList[currentVertex];
            currentVertex++;
        }
        //Sort BoneWeights by weight value to find the top four bones
        qsort(BoneWeights,NumBones,sizeof(BoneNumberWeight),CompareBoneWeights);
        
        //Normalise the top four weights to 1 and ensure they are not all zero
        RwReal WeightScale=BoneWeights[0].Weight+BoneWeights[1].Weight
                            +BoneWeights[2].Weight+BoneWeights[3].Weight;
        if (WeightScale>0.0f)
        {
            WeightScale=1/WeightScale;
            BoneWeights[0].Weight*=WeightScale;
            BoneWeights[1].Weight*=WeightScale;
            BoneWeights[2].Weight*=WeightScale;
            BoneWeights[3].Weight*=WeightScale;
        }
        else
        {
            //all weights zero, but need to ensure that all bones have at least
            //one weight set, so make a sensible guess at which bone to use
        }

        //Found the bone and weight values for this vertex, so copy to RpSkin
        int v=VertexMap[i];
        SkinVertexIndices[VertexMap[i]]=
            BoneWeights[0].BoneNumber
            |(BoneWeights[1].BoneNumber<<8)
            |(BoneWeights[2].BoneNumber<<16)
            |(BoneWeights[3].BoneNumber<<24);
        SkinMatrixWeights[VertexMap[i]].w0=BoneWeights[0].Weight;
        SkinMatrixWeights[VertexMap[i]].w1=BoneWeights[1].Weight;
        SkinMatrixWeights[VertexMap[i]].w2=BoneWeights[2].Weight;
        SkinMatrixWeights[VertexMap[i]].w3=BoneWeights[3].Weight;
    }
    RwFree(BoneWeights);
    BoneWeights=NULL;
}